using System;

namespace ExtendingInterfaces
{
	interface ICompressible
	{
		void Compress();
		void Decompress();
	}

	// Rozszerzanie interfejsu ICompressible o moliwo zapamitania liczby zapisanych bajtw
	interface ILoggedCompressible : ICompressible
	{
		void LogSavedBytes();
	}

	public class Document : ILoggedCompressible
	{

		public Document(string s)
		{
			Console.WriteLine("Tworzenie dokumentu: {0}", s);
		}

		#region

		public void Compress()
		{
			Console.WriteLine("Implementacja metody Compress");
		}

		public void Decompress()
		{
			Console.WriteLine("Implementacja metody Decompress");
		}

		public void LogSavedBytes()
		{
			Console.WriteLine("Implementacja metody LogSavedBytes");
		}

		#endregion // ILoggedCompressible

	}

	class Tester
	{
		public void Run()
		{
			Document doc = new Document("Dokument testowy");

			ILoggedCompressible myLoggedCompressible = doc as ILoggedCompressible;
			if (myLoggedCompressible != null)
			{
				Console.Write("\nWywoanie metod interfejsw ");
				Console.WriteLine("ICompressible i ILoggedCompressible...");
				myLoggedCompressible.Compress();
				myLoggedCompressible.LogSavedBytes();
			}
			else
			{
				Console.WriteLine("Operacja nie powioda si! Nie ILoggedCompressible");
			}
		}

		static void Main()
		{
			Tester t = new Tester();
			t.Run();
		}
	}
}
